const express = require('express');
const router = express.Router();
const { authenticate, authorizeAdmin } = require('../middleware/authMiddleware');
const { validateRegistration, validateVerification } = require('../middleware/userValidation');
const userController = require('../controllers/userController');

// Public routes
router.post('/register', validateRegistration, userController.register);

// Admin only routes
router.get('/pending-verifications', 
  authenticate, 
  authorizeAdmin, 
  userController.getPendingVerifications
);

router.post('/verify/:userId',
  authenticate,
  authorizeAdmin,
  validateVerification,
  userController.verifyUser
);

// Location specific routes - must come before /:userId to avoid path conflicts
router.get('/location/:locationId',
  authenticate,
  authorizeAdmin,
  userController.getUsersByLocation
);

// Get user by ID - admin only
router.get('/:userId',
  authenticate,
  authorizeAdmin,
  userController.getUserById
);

// Get all users - admin only
router.get('/',
  authenticate,
  authorizeAdmin,
  userController.getAllUsers
);

module.exports = router;
