const express = require('express');
const router = express.Router();
const { authenticate } = require('../middleware/authMiddleware');
const {
  validateCreateSupplier,
  validateUpdateSupplier,
  validateUpdateAccount,
  validateSupplierQuery
} = require('../middleware/supplierValidation');
const supplierController = require('../controllers/supplierController');

// All routes require authentication
router.use(authenticate);

// Supplier management routes
router.post('/',
  validateCreateSupplier,
  supplierController.createSupplier
);

router.put('/:id',
  validateUpdateSupplier,
  supplierController.updateSupplier
);

router.get('/:id',
  supplierController.getSupplier
);

router.get('/',
  validateSupplierQuery,
  supplierController.getAllSuppliers
);

// Supplier account routes
router.put('/account/:supplierId',
  validateUpdateAccount,
  supplierController.updateSupplierAccount
);

router.get('/account/:supplierId',
  supplierController.getSupplierAccount
);

module.exports = router;
