const express = require('express');
const router = express.Router();
const { authenticate } = require('../middleware/authMiddleware');
const { requireAdmin, requireHQAdmin } = require('../middleware/adminMiddleware');
const { validateCreateLocation, validateUpdateLocation } = require('../middleware/locationValidation');
const locationController = require('../controllers/locationController');

// All routes require authentication
router.use(authenticate);

// Get all locations - accessible by all authenticated users
router.get('/', locationController.getLocations);

// Get location by ID - accessible by all authenticated users
router.get('/:id', locationController.getLocationById);

// Admin-only routes with additional HQ check
router.post('/', 
  requireAdmin,
  requireHQAdmin,
  validateCreateLocation,
  locationController.createLocation
);

router.put('/:id',
  requireAdmin,
  requireHQAdmin,
  validateUpdateLocation,
  locationController.updateLocation
);

router.delete('/:id',
  requireAdmin,
  requireHQAdmin,
  locationController.deleteLocation
);

module.exports = router;
