const express = require('express');
const router = express.Router();
const { authenticate } = require('../middleware/authMiddleware');
const {
  validateCreateItem,
  validateUpdateItem,
  validateCreateLocation,
  validateUpdateLocation,
  validateUpdateStock,
  validateInventoryQuery
} = require('../middleware/inventoryValidation');
const inventoryController = require('../controllers/inventoryController');

// All routes require authentication
router.use(authenticate);

// Item routes
router.post('/items',
  validateCreateItem,
  inventoryController.createItem
);

router.put('/items/:id',
  validateUpdateItem,
  inventoryController.updateItem
);

router.get('/items/:id',
  inventoryController.getItem
);

router.get('/items',
  validateInventoryQuery,
  inventoryController.getAllItems
);

// Location routes
router.post('/locations',
  validateCreateLocation,
  inventoryController.createLocation
);

router.put('/locations/:id',
  validateUpdateLocation,
  inventoryController.updateLocation
);

router.get('/locations/:id',
  inventoryController.getLocation
);

router.get('/locations',
  validateInventoryQuery,
  inventoryController.getAllLocations
);

// Stock routes
router.put('/stock/:itemId/:locationId',
  validateUpdateStock,
  inventoryController.updateStock
);

router.get('/stock/:itemId/:locationId',
  inventoryController.getStock
);

router.get('/low-stock',
  inventoryController.getLowStock
);

// We're using hardcoded categories in the frontend for now

module.exports = router;
