const express = require('express');
const router = express.Router();
const { authenticate } = require('../middleware/authMiddleware');
const { requireAdmin } = require('../middleware/adminMiddleware');
const { 
  validateInitializeCapital,
  validateTransaction,
  validateDateRange
} = require('../middleware/capitalValidation');
const capitalController = require('../controllers/capitalController');

// All routes require authentication
router.use(authenticate);

// Initialize capital account
router.post('/initialize',
  validateInitializeCapital,
  capitalController.initializeCapitalAccount
);

// Get location capital
router.get('/location/:locationId',
  capitalController.getLocationCapital
);

// Record transaction
router.post('/transaction',
  validateTransaction,
  capitalController.recordTransaction
);

// Get transaction history
router.get('/transactions/:capitalId',
  validateDateRange,
  capitalController.getTransactionHistory
);

// Get capital summary
router.get('/summary/:locationId',
  validateDateRange,
  capitalController.getCapitalSummary
);

module.exports = router;
