const { body, param } = require('express-validator');
const { validateRequest } = require('./validationMiddleware');

const validateCreateLocation = [
  body('name')
    .trim()
    .notEmpty()
    .withMessage('Location name is required')
    .isLength({ max: 100 })
    .withMessage('Location name must be at most 100 characters'),
  
  body('type')
    .isIn(['HQ', 'BRANCH'])
    .withMessage('Type must be either HQ or BRANCH'),
  
  body('address')
    .optional()
    .trim()
    .isLength({ max: 255 })
    .withMessage('Address must be at most 255 characters'),
  
  body('contactPhone')
    .optional()
    .trim()
    .isLength({ max: 20 })
    .withMessage('Contact phone must be at most 20 characters'),
  
  body('contactEmail')
    .optional()
    .trim()
    .isEmail()
    .withMessage('Invalid email format')
    .isLength({ max: 100 })
    .withMessage('Email must be at most 100 characters'),
  
  validateRequest
];

const validateUpdateLocation = [
  param('id')
    .isInt()
    .withMessage('Invalid location ID'),
  
  ...validateCreateLocation
];

module.exports = {
  validateCreateLocation,
  validateUpdateLocation
};
