const { verifyToken } = require('../utils/jwt');
const prisma = require('../config/database');

const authenticate = async (req, res, next) => {
  try {
    const authHeader = req.headers.authorization;
    if (!authHeader?.startsWith('Bearer ')) {
      return res.status(401).json({ error: 'No token provided' });
    }

    const token = authHeader.split(' ')[1];
    const decoded = verifyToken(token);
    
    const user = await prisma.user.findUnique({
      where: { id: decoded.userId },
      select: {
        id: true,
        username: true,
        userRole: true,
        locationId: true,
        isActive: true
      }
    });

    if (!user || !user.isActive) {
      return res.status(401).json({ error: 'User not found or inactive' });
    }

    req.user = user;
    next();
  } catch (error) {
    return res.status(401).json({ error: 'Invalid token' });
  }
};

const requireRole = (roles) => {
  return (req, res, next) => {
    if (!roles.includes(req.user.userRole)) {
      return res.status(403).json({ error: 'Insufficient permissions' });
    }
    next();
  };
};

/**
 * Middleware to check if the user is an admin
 */
const authorizeAdmin = (req, res, next) => {
  console.log(req.user.userRole);
  if (req.user.userRole != 'ADMIN') {
    console.log('Unauthorized. Admin access required.');
    return res.status(403).json({ error: 'Unauthorized. Admin access required.' });
  }
  console.log('Admin access granted.');
  next();
};

module.exports = {
  authenticate,
  requireRole,
  authorizeAdmin
};
