const prisma = require('../config/database');

const requireAdmin = async (req, res, next) => {
  try {
    if (req.user.userRole !== 'ADMIN') {
      return res.status(403).json({ error: 'Admin access required' });
    }

    // Get full admin details
    const admin = await prisma.user.findFirst({
      where: {
        id: req.user.id,
        userRole: 'ADMIN',
        isActive: true
      },
      include: {
        location: {
          select: {
            id: true,
            name: true,
            type: true
          }
        }
      }
    });

    if (!admin) {
      return res.status(403).json({ error: 'Admin access required' });
    }

    // Attach admin details to request
    req.admin = admin;
    next();
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
};

// Middleware to ensure admin is from HQ
const requireHQAdmin = async (req, res, next) => {
  try {
    if (!req.admin?.location || req.admin.location.type !== 'HQ') {
      return res.status(403).json({ error: 'HQ Admin access required' });
    }
    next();
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
};

module.exports = {
  requireAdmin,
  requireHQAdmin
};
